<?php

namespace App\Http\Resources\v1;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'username' => $this->username,
            'mobile' => $this->mobile,
            'avatar' => $this->avatar,
            'access_code' => $this->access_code,
            'territory' => $this->country->name ?? null,
            'created_at' => date('M d, Y', strtotime($this->created_at)),
            'otp' => base64_encode($this->otp).'!#!'.$this->otp
        ];


        if(!empty($this->affiliate)){
            $data['referred_by']= $this->affiliate;
        }

        if(!empty($this->subscription)){
            $subscription           = $this->subscription;
            $subscription->details  = json_decode($subscription->response_data);
            $data['subscription']   = $subscription;
        }

        if(count($this->referredUsers) > 0){
            $data['referred_users']   = $this->referredUsers;
        }


        $is_deleted = !empty($this->deleted_at)?true:false;
        if($is_deleted){
            $data['is_deleted'] = $is_deleted;
        }

        if(!isset($this->accessToken)){
            $data['token'] = [
                'current_token' => request()->bearerToken(),
                'token_type' => 'Bearer',
                'encrypt_token' => $this->currentAccessToken()->token ?? null
            ];
        }

        if(isset($this->accessToken)){
            $data['accessToken'] = $this->accessToken;
            $data['token_type'] = $this->token_type;
        }

        return $data;
    }
}
