<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AutoLogout
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $timeout = config('session.lifetime') * 60; // Convert minutes to seconds

        if (Auth::guard('admin')->check() || Auth::check()) {
            $lastActivity = Session::get('lastActivityTime');
            if ($lastActivity && (time() - $lastActivity > $timeout)) {
                Auth::logout(); // Log the user out
                Auth::guard('admin')->logout();
                Session::forget('lastActivityTime');
                return redirect()->route('home')->with('message', 'You have been logged out due to inactivity.');
            }
            Session::put('lastActivityTime', time());
        }

        return $next($request);
    }
}
