<?php
namespace App\Http\Helpers;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Symfony\Component\Intl\Languages;
use App\Models\UserCart;
use DateTimeZone;
use Countries;
class Bmf{
    
    public function getSessionUser(){

        $user = null;
        if(Auth::guard('admin')->check()){
           $user = Auth::guard('admin')->user();
        }

        return $user;
    }
    
    public function getLogoutUrl(){
        Session::flush();
        Auth::logout();
        return route('logout');
    }

    public function priceTypes(){

        return [
            'Cash Prize', 'Technology', 'Sports', 'Home Decor', 'Vouchers', 
            'Fashion', 'Beauty', 'Food & Drink', 'Holidays', 'Baby & Kids', 'Music', 'Books'];
    }

    public function faqCategories(){

        return [
            'BMF Competitions Tickets', 'Banking', 'Winning', 'Result & Alerts', 'About BMF Competitions'];
    }
  
    public function getCartItemsByIp(){
        $ip_address = request()->ip();
        return UserCart::where('ip_address', $ip_address);
    }

    public function getLanguages(){

        $languages = Languages::getNames();

        return $languages;
    }

    public function getTimeZones(){

        $timezones = DateTimeZone::listIdentifiers();

        return $timezones;
    }

    public function getCountriesList(){

        return Countries::getList('en');
    }
}