<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Illuminate\Support\Carbon;
use App\Http\Traits\Bmf;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use App\Http\Traits\HttpResponses;
use Illuminate\Support\Facades\Mail;
use App\Models\Contests;
use App\Models\UserCart;
use App\Models\Orders;
use App\Models\OrdersItems;
use App\Models\PaymentHistory;
use App\Models\OrdersTickets;
use Illuminate\Support\Facades\Storage;
use App\Services\EmailService;


use Sebdesign\VivaPayments\Enums\TransactionStatus;
use Sebdesign\VivaPayments\Facades\Viva;
use Sebdesign\VivaPayments\Requests\CreatePaymentOrder;
use Sebdesign\VivaPayments\Requests\Customer;
use Sebdesign\VivaPayments\VivaException;
use Illuminate\Http\RedirectResponse;

class WebhookController extends Controller
{
    use Bmf, HttpResponses;

    protected $user;
    protected $cart;
    protected $contest;
    protected $orders;
    protected $orderItems;
    protected $paymentHistory;
    protected $orderTickets;
    protected $emailService;

    public function __construct(
        User $_user,
        UserCart $_cart,
        Contests $_contest,
        Orders  $_orders,
        OrdersItems  $_ordersItems,
        PaymentHistory  $_paymentHistory,
        OrdersTickets $_ordersTickets,
        EmailService $emailService
    ) {
        $this->user             =   $_user;
        $this->cart             =   $_cart;
        $this->contest          =   $_contest;
        $this->orders           =   $_orders;
        $this->orderItems       =   $_ordersItems;
        $this->paymentHistory   =   $_paymentHistory;
        $this->orderTickets     =   $_ordersTickets;
        $this->emailService     =   $emailService;
    }
}
