<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Traits\Bmf;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use App\Http\Traits\HttpResponses;
use App\Repositories\UserRepository;
use Illuminate\Support\Carbon;
use App\Repositories\ContestRepository;
use App\Models\ContactUs;
use App\Models\Subscribers;
use App\Models\News;
use App\Models\Category;



class IndexController extends Controller
{
    use Bmf, HttpResponses;

    protected $user;
    protected $userRepository;

    public function __construct(
        User $_user, 
        UserRepository $userRepository,
        ContestRepository $contestRepository,
        ContactUs $_contact_us,
        Subscribers $_subscribers,
        News $_news,
        Category $_category


    ) {
        $this->user             =   $_user;
        $this->userRepository   =   $userRepository;
        $this->contests         =   $contestRepository;
        $this->contactUs        =   $_contact_us;
        $this->subscribers      =   $_subscribers;
        $this->news      =   $_news;
        $this->category      =   $_category;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = $this->getSessionUser();
        if($user){
            return redirect()->back();
        }

        return view('auth.login');
    }

    //Admin Dashboard
    public function adminDashboard(){
        $user = $this->getSessionUser();
        $news = $this->news->orderBy('id', 'DESC')->count();
        $categories = $this->category->orderBy('id', 'DESC')->count();

        return view('admin.dashboard.index', compact('user', 'news', 'categories'));
    }
}
