<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use App\Http\Traits\Bmf;
use App\Repositories\ContestRepository;
use App\Models\ContactUs;
use App\Models\Subscribers;

class AuthController extends Controller
{

    use Bmf;

    protected $user;
    protected $contests;
    protected $contactUs;
    protected $subscribers;

    public function __construct(
        User $_user,
        ContestRepository $contestRepository,
        ContactUs $_contact_us,
        Subscribers $_subscribers
    ) {
        $this->user         =   $_user;
        $this->contests     =   $contestRepository;
        $this->contactUs    =   $_contact_us;
        $this->subscribers  =   $_subscribers;
    }

    public function index()
    {
        // $user = $this->getSessionUser();
        // if ($user) {
        //     return redirect($this->redirectToDashboard($user));
        // }
        return view('auth.login');
    }

    public function loginAccess(Request $request)
    {
        try {
            $user = $this->user->where('email', $request->username)->first();

            if (!in_array($user->user_type, [1, 2])) {

                return redirect()->back()->with('failed', 'Only Admins can login here');
            }

            if (!$user) {
                return redirect()->back()->with('failed', 'No Credentials Found with this username or email.');
            }
            $username = $request->username;
            $guard = 'admin';

            if (Auth::guard('admin')->attempt(['email' => $username, 'password' => $request->password])) {
                // Authentication passed...
                Auth::guard('admin')->login($user);
                $redirect = $this->redirectToDashboard($user);

                Log::info("Login: " . $user->name . ' as successfully logged in. && Redirected To : ' . $redirect);
                return redirect($redirect)->with('success', $user->name . ' has been successfully logged in. welcome back..!');
            }

            //Failed to authenticate user credentials...
            Log::debug("Failed: Invalid Credentials, Please check Email and Password.");
            return redirect()->back()->with('failed', 'Invalid Credentials, Please check Email and Password.');
        } catch (\Throwable $th) {
            Log::error("Cache: " . $th->getMessage());
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function register()
    {

        return view('auth.sign-up');
    }

    public function userRegistration(Request $request)
    {
        $vv = $this->validate($request, [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|unique:users',
            'password' => 'required|string|min:6',
        ]);
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        Auth::guard('admin')->loginUsingId($user->id);

        // Optionally: Log the user in or redirect to a success page
        return redirect(route('admin.dashboard'));
    }


    private function redirectToDashboard($user)
    {
        return route('admin.dashboard');
    }

    public function logout()
    {
        $guard = 'admin';
        if (!$guard) {
            Session::flush();
            Auth::logout();
            return redirect()->route('login');
        }

        Session::flush();
        Auth::guard($guard)->logout();
        return redirect()->route('login');
    }
}
