<?php

namespace App\Http\Controllers\Application;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Laravel\Socialite\Facades\Socialite;
use Nette\Utils\Random;

class SocialLoginController extends Controller
{
    

    public function redirect($provider){
        return Socialite::driver($provider)->redirect();
    }

    public function callback($provider){
        $user = Socialite::driver($provider)->user();
        $existingUser = User::where('email', $user->email)->first();

        if ($existingUser) {
            Auth::login($existingUser);
            return redirect()->route('home');
        } else {

            User::create([
                'name'              =>  $user->name,
                'email'             =>  $user->email,
                'password'          =>  Hash::make(Str::random(8)),
                'provider_name'     =>  $provider,
                'provider_id'       =>  $user->id,
                'provider_token'    =>  $user->token,
                'user_type'         =>  3,
                'email_verified_at' =>  now()
            ]);

            return redirect()->route('home');
        }
    }

}
