<?php

namespace App\Http\Controllers\Application;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Traits\Bmf as BMF;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Services\core;
use App\Models\User;
use App\Models\UserAdditionalInfo;
use Illuminate\Support\Facades\Route;
use App\Services\EmailService;
use App\Models\ResetPassword;
use App\Models\UserCart;
use Carbon\Carbon;
use App\Models\News;
use App\Models\Category;



class NewsController extends Controller
{
    use BMF;

    protected $emailService;
    protected $user;
    protected $forgetPassword;
    protected $cart;

    public function __construct(
        User $_user,
        EmailService $emailService,
        ResetPassword $forgetPassword,
        UserCart $_cart
    ) {
        $this->user = $_user;
        $this->cart = $_cart;
        $this->emailService = $emailService;
        $this->forgetPassword = $forgetPassword;
    }

public function newsList(Request $request)
{
    // Fetch categories as an associative array (id => category_name)
    $categories = Category::pluck('category_name', 'id'); 
    
    // Base Query
    $query = News::select('id', 'title', 'category_id', 'short_description', 'long_description', 'news_date', 'image')
                 ->orderBy('id', 'asc');

    // Filter by category if provided in the request
    if ($request->has('category_id') && !empty($request->category_id)) {
        $query->where('category_id', $request->category_id);
    }

    // Define pagination size (default to 6 if not provided)
    $perPage = $request->input('per_page');
    // Paginate the results
    $news = $query->paginate($perPage);
    // Base URL for images
    // $Url = "http://localhost/dovehouse-Capital/public/";
    $Url = "https://caferoute66.com/dovehouse/public/";

    // Modify news items
    $news->getCollection()->transform(function ($item) use ($categories, $Url) {
        $item->category_name = $categories[$item->category_id] ?? 'Uncategorized';
        $item->image = !empty($item->image) ? $Url . 'assets/news/' . $item->image : null;
        return $item;
    });

    // Check if news is empty
    if ($news->isEmpty()) {
        return response()->json(['message' => 'No news found for this category'], 404);
    }
    return $news;exit();

    // Return paginated response
    return response()->json([
        'status' => 200,
        'message' => 'News fetched successfully',
        'data' => $news
    ], 200);
}


}