<?php

namespace App\Http\Controllers\Application;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contests;
use App\Http\Traits\Bmf as BMF;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Carbon;
use App\Models\SiteSettings;

class ContestController extends Controller
{
    use BMF;

    protected $contests;
    protected $siteSettings;

    public function __construct(
        Contests $_contests,
        SiteSettings $_siteSettings
    ) {
        $this->contests = $_contests;
        $this->siteSettings = $_siteSettings;
    }

    public function contestListing(Request $request)
    {
        $contests = $this->contests->where(function ($query) use ($request) {
            $query->whereDate('contest_end', '>', date('Y-m-d'));
            // $query->where(
            //     'qty',
            //     '!=',
            //     function ($subQuery) {
            //         $subQuery->from('orders_tickets')
            //             ->selectRaw('COUNT(*)')
            //             ->whereColumn('orders_tickets.contest_id', 'contests.id');
            //     }
            // );
        });
        if (isset($request->search)) {
            $contests->where('title', 'like', '%' . $request->search . '%');
        }
        $contests = $contests
            ->orderByRaw('DATEDIFF(contests.contest_end, ?) ASC', [Carbon::now()->toDateString()])
            ->get();
        return view('application.contest.contest-listing', compact('contests'));
    }

    public function contestDetails(Request $request)
    {
        $contest = $this->contests->find($request->id);
        $endDate = !empty($contest->contest_end) ? Carbon::parse($contest->contest_end) : null;
        $drawDate = !empty($contest->draw_date) ? Carbon::parse($contest->draw_date) : null;
        $soldOutImage = $this->siteSettings->getDetailsByType('sold_out_image')->first();
        $soldOutImg = null;
        if (!empty($soldOutImage->image) && Storage::exists($soldOutImage->image)) {
            $soldOutImg = asset(Storage::url($soldOutImage->image));
        }
        $ticketSoldOut = $contest->orderTickets->count();
        return view('application.contest.contest-details', compact('contest', 'endDate', 'soldOutImg', 'ticketSoldOut', 'drawDate'));
    }
}
