<?php

namespace App\Http\Controllers\Application;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactPage;
use App\Models\ContactUs;
use App\Http\Traits\Bmf as BMF;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\AboutUs;
use App\Mail\ContactRequestEmail;
use Illuminate\Support\Facades\Mail;
use App\Models\Contests;
use App\Models\HomePage;
use App\Models\UserCart;
use Jackiedo\Cart\Cart;
use Carbon\Carbon;


class CheckoutController extends Controller
{
    use BMF;

    protected $contactUs;
    protected $contactPage;
    protected $aboutUs;
    protected $contests;
    protected $homepage;
    protected $user_cart;
    protected $cartItems;
    protected $cart;

    public function __construct(
        ContactUs $_contact_us,
        ContactPage $_contact_page,
        AboutUs $_about_us,
        Contests $_contests,
        HomePage $_homepage,
        UserCart $user_cart,
        Cart $_cart,
    ) {
        $this->contactUs    =   $_contact_us;
        $this->contactPage  =   $_contact_page;
        $this->aboutUs      =   $_about_us;
        $this->contests     =   $_contests;
        $this->homepage     =   $_homepage;
        $this->user_cart    =   $user_cart;
        $this->cart         =   $_cart;

        $this->cartItems = app('bmf')->getCartItemsByIp();
    }

    public function getCartItemsList($user, $ip_address)
    {
        return $this->user_cart->where(function ($query) use ($user, $ip_address) {
            $query->where('ip_address', $ip_address)
                ->orWhere('user_id', $user?->id);
        })->get();
    }

    // User Cart
    public function addItemsToCart(Request $request)
    {
        try {
            $user = $request->user() ?? null;
            $ip_address = $request->ip();
            $cart = $this->user_cart->where(function ($query) use ($user, $ip_address) {
                $query->where('ip_address', $ip_address)
                    ->orWhere('user_id', $user?->id);
            })->where('item_id', $request->contest_id)->first();

            $contest = $this->contests->find($request->contest_id);
            $cartItems = $this->cartItems;

            if ($request->quantity <= 0) {
                $cart = $request->user()->ipCart ?? [];
                return response()->json(['status' => false, 'message' => 'Invalid Quantity, At least quantity should have 1.', 'data' => $cart], 200);
            }

            if (!$cart) {
                $cart = $this->user_cart->create([
                    'ip_address'    =>  $ip_address,
                    'item_id'       =>  $request->contest_id,
                    'quantity'      =>  $request->quantity,
                    'price'         =>  $contest->price,
                    'total_price'   =>  $contest->price * $request->quantity,
                    'user_id'       =>  $user->id ?? null
                ]);

                $item = $cart;
                return response()->json(['status' => true, 'message' => 'Item Added To Cart.', 'data' => $item], 200);
            }

            if ($request->quantity <= 0) {
                $cart->delete();
                $cartItems = $this->cartItems->get() ?? [];
                return response()->json(['status' => false, 'message' => 'Item Deleted From Cart.', 'data' => $cartItems], 200);
            }

            $cart->quantity      =   $request->quantity;
            $cart->price         =   $contest->price;
            $cart->total_price   =   $contest->price * $request->quantity;
            $cart->user_id       =   $user->id ?? null;
            $cart->save();

            $cartItems = $this->getCartItemsList($user, $ip_address) ?? [];
            return response()->json(['status' => true, 'message' => 'Item Details Updated In Cart.', 'data' => $cartItems], 200);
        } catch (\Throwable $th) {
            return response()->json(['status' => false, 'message' => $th->getMessage()], 500);
        }
    }


    public function getCartItems(Request $request)
    {
        $user = $request->user() ?? null;
        $ip_address = $request->ip();
        $cartItems = $this->getCartItemsList($user, $ip_address) ?? [];
        $totalAmount = 0;
        foreach ($cartItems as $key => $value) {
            $contest = $value->item;
            $totalAmount += $value->price * $value->quantity;
        }
        return response()->json(['status' => true, 'message' => 'Cart Items.', 'data' => $cartItems, 'count' => count($cartItems), 'total_amount' => \number_format($totalAmount, 2, '.')], 200);
    }


    public function deleteCartItem(Request $request)
    {
        $cart = $this->user_cart->find($request->id);
        if (!$cart) {
            return response()->json(['status' => false, 'message' => 'Invalid request to delete cart item.'], 200);
        }


        if ($cart->delete()) {
            $cartItems = $this->cartItems->get() ?? [];
            $totalAmount = 0;
            foreach ($cartItems as $key => $value) {
                $contest = $value->item;
                $totalAmount += $value->price * $value->quantity;
            }

            return response()->json(['status' => true, 'message' => 'Cart Item Deleted.', 'data' => $cartItems, 'count' => count($cartItems), 'total_amount' => \number_format($totalAmount, 2, '.')], 200);
        }


        $cartItems = $this->cartItems->get() ?? [];
        $totalAmount = 0;
        foreach ($cartItems as $key => $value) {
            $contest = $value->item;
            $totalAmount += $value->price * $value->quantity;
        }
        return response()->json(['status' => false, 'message' => 'Failed To Delete Cart Item.', 'data' => $cartItems, 'count' => count($cartItems), 'total_amount' => \number_format($totalAmount, 2, '.')], 200);
    }

    public function emptyCartItems(Request $request)
    {
        $cart = $this->cartItems->get();
        if ($cart->count() < 0) {
            return response()->json(['status' => false, 'message' => 'Invalid request or No Items to delete.'], 200);
        }


        $delete = $this->cartItems->delete();
        if ($delete) {
            $cartItems = $this->cartItems->get() ?? [];
            $totalAmount = 0;
            foreach ($cartItems as $key => $value) {
                $contest = $value->item;
                $totalAmount += $value->price * $value->quantity;
            }

            return response()->json(['status' => true, 'message' => 'Cart Items Deleted.', 'data' => $cartItems, 'count' => count($cartItems), 'total_amount' => \number_format($totalAmount, 2, '.')], 200);
        }

        return response()->json(['status' => false, 'message' => 'Failed To Delete Cart Items.'], 200);
    }

    //
    public function cart(Request $request)
    {
        $user = $request->user() ?? null;
        $ip_address = $request->ip();
        $cartItems = $this->getCartItemsList($user, $ip_address) ?? [];
        $this->checkCartUpdateUserIds($request, $cartItems);
        $contests =
            $this->contests->where(function ($query) use ($request) {
                $query->whereDate('contest_end', '>', date('Y-m-d'));
                // $query->where(
                //     'qty',
                //     '!=',
                //     function ($subQuery) {
                //         $subQuery->from('orders_tickets')
                //             ->selectRaw('COUNT(*)')
                //             ->whereColumn('orders_tickets.contest_id', 'contests.id');
                //     }
                // );
            })
            ->where('featured', 1)
            ->orderByRaw('DATEDIFF(contests.contest_end, ?) ASC', [Carbon::now()->toDateString()])
            ->limit(6)
            ->get();
        return view('application.checkout.cart', compact('cartItems', 'contests'));
    }

    public function checkoutCart(Request $request)
    {
        $user = $request->user() ?? null;
        $ip_address = $request->ip();
        $cartItems = $this->getCartItemsList($user, $ip_address) ?? [];
        $this->checkCartUpdateUserIds($request, $cartItems);
        return view('application.checkout.checkout', compact('cartItems'));
    }

    public function checkCartUpdateUserIds($request, $cartItems)
    {
        if (count($cartItems)) {
            $user = Auth::user() ?? null;
            if ($user) {
                foreach ($cartItems as $key => $cartItem) {
                    $cartItem->user_id = $user->id;
                    $cartItem->save();
                }
            }
        }

        return $cartItems;
    }
}
