<?php

namespace App\Http\Controllers\Application;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Traits\Bmf;
use Illuminate\Support\Facades\Auth;


class AccountController extends Controller
{
    use Bmf;

    protected $userRepository;

    public function __construct(\App\Repositories\UserRepository $userRepository)
    {

        $this->userRepository = $userRepository;
    }

    public function updateUserInfo(Request $request)
    {

        $request = $request->all();
        $userInputs = $request['user'] ?? array();
        $userId = $request['id'] ?? '';

        $this->userRepository->updateInfo($userId, $request);

        session()->flash('success', 'User account has been updated successfully!');

        if (isset($userInputs['password'])) {
            Auth::logout();
        }
        return redirect()->route('frontend.user.dashboard')->with('success', 'User account has been updated successfully!');
    }
}
