<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use App\Http\Traits\Bmf;


class UserController extends Controller
{
    
    use Bmf;

    protected $user;
    
    public function __construct(User $_user)
    {
        //$this->middleware('role:admin'); // Restrict access to admins only
        $this->user  =   $_user;

    }

    public function index()
    {
        $users = User::with('roles')->where('user_type', '!=', 3)->paginate(10);
        $roles = Role::all();
        return view('admin.users.list', compact('users', 'roles'));
    }

    public function deactivatedList()
    {
        $users = User::onlyTrashed()->with('roles')->paginate(10);
        $roles = Role::all();
        return view('admin.users.deactivated_list', compact('users', 'roles'));
    }

    public function create()
    {
        $roles = Role::all();
        return view('admin.users.create', compact('roles'));
    }

    public function store(Request $request)
    {
        $user = null;
        if(!$request->id){
            $validator = Validator::make($request->all(), [
                'first_name' => 'required|string|max:255',
                'last_name' => 'required|string|max:255',
                'email' => 'required|string|email|unique:users',
                'password' => 'required|string|min:6',
                'role' => 'required',
            ]);
        }else{
            $user = User::find($request->id);
            $validator = Validator::make($request->all(), [
                'first_name' => 'required|string|max:255',
                'last_name' => 'required|string|max:255',
                'email' => 'required|string|email|unique:users,email,' . $user->id,
            ]);
        }


        if ($validator->fails()) {
            session()->flash('error', $validator->errors()->first());
            return redirect()->back()->withErrors($validator);
        }

        if(!$user){
            $user = User::create([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'name'  => $request->first_name.' '.$request->last_name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'user_type' => 2
            ]);

        }else{
            $user->first_name = $request->first_name;
            $user->last_name = $request->last_name;
            $user->name = $request->first_name.' '.$request->last_name;
            $user->email = $request->email;
            if(isset($request->password) && !empty($request->password)){
                $user->password = Hash::make($request->password);
            }
            $user->save();
        }


        session()->flash('success', 'User has been created successfully!');

        return redirect()->route('admin.users')->with('success', 'User created successfully!');
    }

    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::all();
        return view('admin.users.create', compact('user', 'roles'));
    }

    public function updateProfile(Request $request, User $user)
    {   
        $data['first_name'] = $request->input('user')['first_name'];
        $data['last_name'] = $request->input('user')['last_name'];
        $data['email'] = $request->input('user')['email'];
        $data['mobile'] = $request->input('additional')['phone'] ?? null;
        $data['name'] = $data['first_name'].''.$data['last_name'];
        $user = $this->getSessionUser();
        if ($user) {
            $Save = $user->update($data);
            if($Save)
            {
                Session::put('name', $data['name']);
                Session::put('email', $data['email']);
                Session::save();
                return back()->with('success', 'User updated successfully!');
            }
            else
            {
                return back()->with('error', 'Something went wrong!');

            }
        } else {
            return back()->with('error', 'User not found!');
        }

       
    }

    public function delete($id, $type){

        $user = User::find($id);
        if($user){
            $user->status = 0;
            $user->email_verified_at = null;
            $user->save();

            if($user->delete()){
                if($type=='user'){
                    session()->flash('success', 'User has been deleted successfully');
                    return redirect()->route('admin.users');
                }else{
                    session()->flash('success', 'Customer has been deleted successfully');
                    return redirect()->route('admin.customers');
                }
            }

            session()->flash('failed', 'Sorry, Failed to delete record.');
            return redirect()->back();
        }else{
            session()->flash('failed', 'Sorry Invalid request to delete record.');
            return redirect()->back();
        }



    }

    public function UpdateAdminPassword(Request $request)
	{

        $request->validate([
            'password' => 'required|min:8|confirmed',
        ]);
        try {
            // Get the authenticated user
            $user = $this->getSessionUser();
            // Update the password
            $user->password = Hash::make($request->password);
            $user->save();
    
            // Redirect with success message
            return redirect()->back()->with('success', 'Password updated successfully.');
        } catch (\Exception $e) {
            // Handle errors
            return redirect()->back()->with('error', 'Something went wrong. Please try again.');
        }

		
	}

    public function restoreDeleteRecord($id, $type){

        $user = User::onlyTrashed()->find($id);
        if($user){
            $user->status = 1;
            $user->email_verified_at = now();
            $user->save();

            if($user->restore()){
                if($type=='user'){
                    session()->flash('success', 'User has been restored successfully');
                    return redirect()->route('admin.users');
                }else{
                    session()->flash('success', 'Customer has been restored successfully');
                    return redirect()->route('admin.customers');
                }
            }

            session()->flash('failed', 'Sorry, Failed to restore record.');
            return redirect()->back();
        }else{
            session()->flash('failed', 'Sorry Invalid request to restore record.');
            return redirect()->back();
        }


        if($type=='user'){
            session()->flash('success', 'User has been deleted successfully');
            return redirect()->route('admin.users');
        }else{
            session()->flash('success', 'Customer has been deleted successfully');
            return redirect()->route('admin.customers');
        }
    }
}
