<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Orders;
use App\Models\OrdersTickets;
class TransactionsController extends Controller
{
    public function index(){

        $page = request()->input('page', 1);
        $perPage = 10;

        $transactions = Orders::join('orders_items', 'orders_items.order_id', 'orders.id')
                    ->join('contests', 'contests.id', 'orders_items.contest_id')
                    ->select(
                        'orders.id as order_id',
                        'orders_items.quantity',
                        'orders_items.contest_id',
                        'orders.created_at as date', 
                        'contests.title as contest_title',
                        'contests.contest_no',
                        'orders_items.total as grand_total',
                        'orders.payment_status'
                    )
                    ->orderBy('orders.id', 'desc')
                    ->get();
        return view('admin.transactions.list', compact('transactions'));
    }    
}
