<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SiteSettings;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use App\Http\Traits\HttpResponses;
use App\Http\Traits\Bmf;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\SettingsRequest;
// use App\Http\Requests\SettingsUpdateRequest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;



class SettingsController extends Controller
{
    use HttpResponses, Bmf;

    protected $siteSettings;
    protected $user;


    public function __construct(
        SiteSettings $siteSettings,
        User $_user,

    ) {
        $this->siteSettings = $siteSettings;
        $this->user         =   $_user;
    }


    public function createOrEditSettings($id) {
        if($id){
            $user = $this->user->where('id', $id)->first();
            return view('admin.settings.edit_site_details', compact('user'));
        }

        return view('admin.settings.add_site_details');
    }


    public function saveSettings(SettingsRequest $request){
        try {
            $siteDetails = $this->siteSettings->getDetailsByType('site_details')->first();
            if($siteDetails){
                return redirect()->back()->with('failed', 'Already saved settings');
            }

            $response = DB::transaction(function () use ($request) {

                $data = [
                    'title' => $request->name,
                    'mobile' => $request->mobile,
                    'email' => $request->email,
                    'copyrights' => $request->copy_rights,
                    'type' => 'site_details'
                ];

                $settings = $this->siteSettings->create($data);
                if ($settings) {
                    if(isset($request->logo) && !empty($request->logo)){
                        $logo = $this->uploadWithName($request, 'logo', 'uploads/settings');
                        $settings->logo = $logo['path'] ?? null;
                        $settings->save();
                    }

                    if(isset($request->fav_icon) && !empty($request->fav_icon)){
                        $favIcon = $this->uploadWithName($request, 'fav_icon', 'uploads/settings');
                        $settings->fav_icon = $favIcon['path'] ?? null;
                        $settings->save();
                    }

                    if(isset($request->sold_out_image) && !empty($request->sold_out_image)){
                        $soldOutImage = $this->uploadWithName($request, 'sold_out_image', 'uploads/settings');
                        $this->siteSettings->create([
                            'image' =>  $soldOutImage['path'] ?? null,
                            'type'  =>  'sold_out_image'
                        ]);
                    }

                    //Social Media links save
                    if(isset($request->socialmedia) && !empty($request->socialmedia)) {
                        foreach ($request->socialmedia as $key => $value) {
                            $this->siteSettings->create([
                                'title' => $key,
                                'url' => $value,
                                'type' => 'social_media'
                            ]);
                        }
                    }


                    return $this->objectCreated('Settings added successfully.', $settings);
                }

                return $this->validation('Failed to add settings details.');
            });

            $response = $response->getData();
            if($response->status){
                return redirect()->back()->with('success', $response->message);
            }

            return redirect()->back()->with('failed', $response->message);

        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }


}
