<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RolesController extends Controller
{
    public function __construct()
    {
        //$this->middleware('role:admin'); // Restrict access to admins only
    }

    public function index()
    {
        $roles = Role::paginate(10);
        return view('admin.roles.list', compact('roles'));
    }

    public function create()
    {
        return view('admin.roles.create');
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255|unique:roles',
        ]);

        $role = Role::create(['name' => $request->name, 'guard_name'=> 'admin']);
        foreach($request->permission as $permission){

            $checkExistingPermission = Permission::where(['name' => $permission, 'guard_name'=>'admin'])->first();
            if(!$checkExistingPermission){
                $permission = Permission::create(['name' => $permission, 'guard_name'=> 'admin']);
            }
        }
        return redirect()->route('admin.roles')->with('success', 'Role created successfully!');
    }

    public function edit(User $user)
    {
        $roles = Role::all();
        return view('admin.roles.edit', compact('user', 'roles'));
    }

    public function update(Request $request, User $user)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|unique:users,email,' . $user->id, //
        ]);
    }
}
