<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Questions;
use App\Models\QuestionOptions;
use Validator;
use Str;
use DB;

class QuestionsController extends Controller
{
    protected $questionsRepository;

    public function __construct(\App\Repositories\QuestionsRepository $questionsRepository)
    {
        $this->questionsRepository = $questionsRepository;
    }

    public function index()
    {
        $questions = Questions::orderBy('id', 'desc')->paginate(10);
        return view('admin.questions.list', compact('questions'));
    }

    public function add()
    {
        return view('admin.questions.create');
    }

    public function store(Request $request)
    {
        if (!isset($request->correct_answer)) {
            return redirect()->back()->with('failed', 'Please choose correct answer.');
        }
        $input = $request->all();
        $correctAnswer = $input['option'][$request->correct_answer ?? 0];
        $input['correct_answer'] = $correctAnswer;
        $question = $this->questionsRepository->create($input);
        if ($question) {
            $options = collect($input['option'])->map(function ($option) use ($question) {
                return new QuestionOptions(['option' => $option]);
            });
            $question->options()->saveMany($options);

            $correctAnswerOption = QuestionOptions::where('option', $correctAnswer)->first();
            $question->correct_answer_id = $correctAnswerOption->id;
            $question->save();

            return redirect()->route('admin.questions-list')->with('success', 'Question has been created successfully.');
        }

        return redirect()->back()->with('failed', 'Invalid request to save question & answer.');
    }

    public function updateView($questionId)
    {

        $question = Questions::with('options')->where('id', $questionId)->first();
        return view('admin.questions.update', compact('question'));
    }

    public function update(Request $request)
    {
        if (!isset($request->correct_answer)) {
            return redirect()->back()->with('failed', 'Please choose correct answer.');
        }

        $input = request()->all();
        $orgOptions = $input['option'];
        $resetOptions = array_values($orgOptions);
        $correctAnswer = $resetOptions[$request->correct_answer ?? 0];
        $question = Questions::find($input['question_id']);
        if ($question && count($input['option']) > 0) {
            $question->question = $input['question'];
            $question->correct_answer = $correctAnswer;
            $question->save();
            foreach ($input['option'] as $k => $option) {
                $inputData = ['option' => $option];
                if ($question) {
                    $save = QuestionOptions::where('id', $k)->update($inputData);
                } else {
                    $save = QuestionOptions::create($inputData);
                }
            }

            $correctAnswerOption = QuestionOptions::where('option', $correctAnswer)->first();
            $question->correct_answer_id = $correctAnswerOption->id;
            $question->save();
            return redirect()->route('admin.questions-list')->with('success', 'Question & answer updated successfully!');
        }

        return redirect()->back()->with('failed', 'Invalid request to update question & answer.');
    }

    public function deleteQuestion()
    {

        $id = request()->questionId;
        if ($id) {

            $question = Questions::find($id);
            $delete = $question->delete();

            if ($delete) {
                session()->flash('success', 'Question has been deleted successfully!');

                return redirect()->route('admin.questions-list')->with('success', 'Question deleted successfully!');
            } else {

                session()->flash('success', 'Something went wrong, please try again!');

                return redirect()->route('admin.questions-list')->with('error', 'Question not deleted');
            }
        }
    }
}
