<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Http\Traits\Bmf;
use App\Models\AboutUs;

class MasterController extends Controller
{
  use Bmf;

  public function __construct(
    AboutUs $_about_us
  ) {
    $this->aboutUs = $_about_us; 
  }

  public function termServices(Request $request){
    $terms  =   $this->aboutUs->where('type', 'terms_services')->first();
    return view('admin.terms_services', compact('terms'));
  }

  public function termServiceSave(Request $request){
    try {
        $terms  =   $this->aboutUs->where('type', 'terms_services')->first();
        if(!$terms){
            $terms = $this->aboutUs->create([
                'title'         =>  $request->title,
                'description'   =>  $request->description,
                'type'          =>  'terms_services'
            ]);
        }else{
            $terms->title         =  $request->title;
            $terms->description   =  $request->description;
            $terms->save();
        }

        return redirect()->back()->with('success', 'Terms and Services saved successfully,');

    } catch (\Throwable $th) {
        return redirect()->back()->with('failed', $th->getMessage());
    }
  }

  public function privacy(Request $request){
    $privacy  =   $this->aboutUs->where('type', 'privacy')->first();
    return view('admin.privacy', compact('privacy'));
  }

  public function privacySave(Request $request){
    try {
        $terms  =   $this->aboutUs->where('type', 'privacy')->first();
        if(!$terms){
            $terms = $this->aboutUs->create([
                'title'         =>  $request->title,
                'description'   =>  $request->description,
                'type'          =>  'privacy'
            ]);
        }else{
            $terms->title         =  $request->title;
            $terms->description   =  $request->description;
            $terms->save();
        }

        return redirect()->back()->with('success', 'Terms and Services saved successfully,');

    } catch (\Throwable $th) {
        return redirect()->back()->with('failed', $th->getMessage());
    }
  }

  public function disclaimer(Request $request){
    $disclaimer  =   $this->aboutUs->where('type', 'disclaimer')->first();
    return view('admin.disclaimer', compact('disclaimer'));
  }

  public function disclaimerSave(Request $request){
    try {
      $terms  =   $this->aboutUs->where('type', 'disclaimer')->first();
      if(!$terms){
        $terms = $this->aboutUs->create([
          'title'         =>  $request->title,
          'description'   =>  $request->description,
          'type'          =>  'disclaimer'
        ]);
      }else{
        $terms->title         =  $request->title;
        $terms->description   =  $request->description;
        $terms->save();
      }

      return redirect()->back()->with('success', 'Disclaimer saved successfully,');

    } catch (\Throwable $th) {
        return redirect()->back()->with('failed', $th->getMessage());
    }
  }
}
