<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\Bmf;
use App\Models\HomePage;

class HomepageController extends Controller
{
    use Bmf;

    public function __construct(
        HomePage $_homepage
    ) {
        $this->homepage = $_homepage;
    }

    public function index(Request $request){
        $banner     =   $this->homepage->where('type', 'banner')->first();
        $howToPlay  =   $this->homepage->where('type', 'how_to_play')->first();
        $context    =   $this->homepage->where('type', 'context')->first();
        $feature    =   $this->homepage->where('type', 'feature')->first();
        $support    =   $this->homepage->where('type', 'support')->first();
        $supportTeam    =   $this->homepage->where('type', 'support_team')->first();
        $supportFaqs    =   $this->homepage->where('type', 'support_rfq')->first();
        return view('admin.homepage.index', compact('banner', 'howToPlay', 'context', 'feature', 'support', 'supportTeam', 'supportFaqs'));
    }

    public function store(Request $request){
        $validator = Validator::make($request->all(), [
            // 'name' => 'required|string|max:255',
        ]);

        try{

            $response = DB::transaction(function () use ($request) {
                $banner = $this->homepage;
                $imgData = null;

                // Banner Session create and update
                if(isset($request->banner)){
                    $bannerData = $request->banner;
                    $banner = $this->homepage->where('type', 'banner')->first();
                    $imgData = null;
                    if(!empty($bannerData['image'])){
                        $imgData = $this->uploadWithFile($bannerData['image'], 'uploads/homepage/banners');
                    }
                    if(!$banner){
                        $saveBanner = $this->homepage->create([
                            'title'         =>  $bannerData['title'],
                            'sub_title'     =>  $bannerData['sub_title'],
                            'description'   =>  $bannerData['description'],
                            'key'           =>  $bannerData['buttonTitle'],
                            'value'         =>  $bannerData['buttonURL'],
                            'type'          =>  'banner',
                            'image'         =>  $imgData['path'] ?? null,
                        ]);
                    }else{

                        if(isset($imgData['path']) && Storage::exists($imgData['path'])){
                            if(Storage::exists($banner->image)) Storage::delete($banner->image);
                        }

                        $banner->title          =   $bannerData['title'];
                        $banner->sub_title      =   $bannerData['sub_title'];
                        $banner->description    =   $bannerData['description'];
                        $banner->key            =   $bannerData['buttonTitle'];
                        $banner->value          =   $bannerData['buttonURL'];
                        $banner->image          =   $imgData['path'] ?? $banner->image;
                        $banner->save();
                    }
                }

                // How to play session create and update
                if(isset($request->howToPlay)){
                    $howToPlayData  =   $request->howToPlay;
                    $howToPlay      =   $this->homepage->where('type', 'how_to_play')->first();
                    if(!$howToPlay){
                        $saveHowToPlay = $this->homepage->create([
                            'title'         =>  $howToPlayData['title'],
                            'sub_title'     =>  $howToPlayData['sub_title'],
                            'description'   =>  $howToPlayData['description'],
                            'type'          =>  'how_to_play'
                        ]);


                        if($saveHowToPlay && isset($howToPlayData['steps'])){
                            foreach($howToPlayData['steps'] as $key => $step){
                                $imgData = $this->uploadWithFile($step['image'], 'uploads/homepage/howToPlay_steps');
                                $this->homepage->create([
                                    'title'         =>  $step['title'],
                                    'sub_title'     =>  $step['sub_title'],
                                    'image'         =>  $imgData['path'] ?? null,
                                    'type'          =>  'how_to_play_steps',
                                    'reference_id'  =>  $saveHowToPlay->id
                                ]);
                            }
                        }
                    }else{
                        $howToPlay->title         =  $howToPlayData['title'];
                        $howToPlay->sub_title     =  $howToPlayData['sub_title'];
                        $howToPlay->description   =  $howToPlayData['description'];
                        if($howToPlay->save() && isset($howToPlayData['steps'])){
                            foreach($howToPlayData['steps'] as $key => $step){
                                $imgData = null;
                                $htpData = $howToPlay->moreRelatedData[$key - 1] ?? [];
                                if(isset($step['image']) && !empty($step['image'])){
                                    $imgData = $this->uploadWithFile($step['image'], 'uploads/homepage/howToPlay_steps');
                                    if(isset($imgData['path']) && Storage::exists($imgData['path'])){
                                        if(isset($htpData->image) && Storage::exists($htpData->image)) Storage::delete($htpData->image);
                                    }
                                }

                                if($htpData){
                                    $htpData->title         =  $step['title'];
                                    $htpData->sub_title     =  $step['sub_title'];
                                    $htpData->image         =  isset($imgData['path']) ? $imgData['path'] : $htpData->image;
                                    $htpData->save();
                                }else{
                                    $this->homepage->create([
                                        'title'         =>  $step['title'],
                                        'sub_title'     =>  $step['sub_title'],
                                        'image'         =>  isset($imgData['path']) ? $imgData['path'] : $htpData->image,
                                        'type'          =>  'how_to_play_steps',
                                        'reference_id'  =>  $howToPlay->id
                                    ]);
                                }
                            }
                        }
                    }
                }

                // Context session create and update
                if(isset($request->context)){
                    $contextData =  $request->context;
                    $context     =  $this->homepage->where('type', 'context')->first();
                    if(!$context){
                        $saveContext = $this->homepage->create([
                            'title'         =>  $contextData['title'],
                            'sub_title'     =>  $contextData['sub_title'],
                            'description'   =>  $contextData['description'],
                            'type'          =>  'context'
                        ]);
                    }else{
                        $context->title         =  $contextData['title'];
                        $context->sub_title     =  $contextData['sub_title'];
                        $context->description   =  $contextData['description'];
                        $context->save();
                    }
                }

                // Feature details create and update
                if(isset($request->feature)){
                    $featureData    =  $request->feature;
                    $feature        =  $this->homepage->where('type', 'feature')->first();
                    if(!$feature){
                        $saveFeature = $this->homepage->create([
                            'title'         =>  $featureData['title'],
                            'sub_title'     =>  $featureData['sub_title'],
                            'description'   =>  $featureData['description'],
                            'value'         =>  $featureData['buttonURL'],
                            'type'          =>  'feature'
                        ]);

                        if($saveFeature && isset($featureData['steps'])){
                            foreach($featureData['steps'] as $key => $step){
                                $imgData = $this->uploadWithFile($step['image'], 'uploads/homepage/feature_steps');
                                $this->homepage->create([
                                    'title'         =>  $step['title'],
                                    'sub_title'     =>  $step['sub_title'],
                                    'image'         =>  $imgData['path'] ?? null,
                                    'type'          =>  'feature_steps',
                                    'reference_id'  =>  $saveFeature->id
                                ]);
                            }
                        }
                    }else{
                        $feature->title         =  $featureData['title'];
                        $feature->sub_title     =  $featureData['sub_title'];
                        $feature->description   =  $featureData['description'];
                        $feature->value         =  $featureData['buttonURL'] ?? $feature->value;
                        if($feature->save() && isset($featureData['steps'])){
                            foreach($featureData['steps'] as $key => $step){
                                $imgData = null;
                                $fsData = $feature->moreRelatedData[$key - 1] ?? [];
                                if(isset($step['image']) && !empty($step['image'])){
                                    $imgData = $this->uploadWithFile($step['image'], 'uploads/homepage/feature_steps');
                                    if(isset($imgData['path']) && Storage::exists($imgData['path'])){
                                        if(isset($fsData->image) && Storage::exists($fsData->image)) Storage::delete($fsData->image);
                                    }
                                }

                                if($fsData){
                                    $fsData->title         =  $step['title'];
                                    $fsData->sub_title     =  $step['sub_title'];
                                    $fsData->image         =  isset($imgData['path']) ? $imgData['path'] : $fsData->image;
                                    $fsData->save();
                                }else{
                                    $this->homepage->create([
                                        'title'         =>  $step['title'],
                                        'sub_title'     =>  $step['sub_title'],
                                        'image'         =>  isset($imgData['path']) ? $imgData['path'] : $fsData->image,
                                        'type'          =>  'feature_steps',
                                        'reference_id'  =>  $feature->id
                                    ]);
                                }
                            }
                        }
                    }
                }

                // Support create and update
                if(isset($request->support)){
                    $supportData    =   $request->support;
                    $support        =   $this->homepage->where('type', 'support')->first();
                    if(!$support){
                        $saveSupport = $this->homepage->create([
                            'title'         =>  $supportData['title'],
                            'sub_title'     =>  $supportData['sub_title'],
                            'description'   =>  $supportData['description'],
                            'type'          =>  'support'
                        ]);


                        if($saveSupport && isset($supportData['team'])){
                            $team = $supportData['team'];
                            $imgData = $this->uploadWithFile($team['image'], 'uploads/homepage/support_team');
                            $this->homepage->create([
                                'title'         =>  $team['title'],
                                'sub_title'     =>  $team['sub_title'],
                                'image'         =>  $imgData['path'] ?? null,
                                'type'          =>  'support_team',
                                'key'           =>  'contact',
                                'value'         =>  json_encode($team['contact']),
                                'reference_id'  =>  $saveSupport->id
                            ]);
                        }

                        if($saveSupport && isset($supportData['rfq'])){
                            $rfq = $supportData['rfq'];
                            $imgData = $this->uploadWithFile($rfq['image'], 'uploads/homepage/support_rfq');
                            $this->homepage->create([
                                'title'         =>  $rfq['title'],
                                'sub_title'     =>  $rfq['sub_title'],
                                'image'         =>  $imgData['path'] ?? null,
                                'type'          =>  'support_rfq',
                                'key'           =>  'button',
                                'value'         =>  json_encode($rfq['button']),
                                'reference_id'  =>  $saveSupport->id
                            ]);
                        }
                    }else{
                        $support->title         =  $supportData['title'];
                        $support->sub_title     =  $supportData['sub_title'];
                        $support->description   =  $supportData['description'];
                        if($support->save()){
                            $supportTeam    =   $this->homepage->where('type', 'support_team')->first();
                            $supportFaqs    =   $this->homepage->where('type', 'support_rfq')->first();

                            if($supportTeam && isset($supportData['team'])){
                                $team = $supportData['team'];
                                $imgData = null;
                                if(isset($team['image'])){
                                    $imgData = $this->uploadWithFile($team['image'], 'uploads/homepage/support_team');
                                    if(isset($imgData['path']) && Storage::exists($imgData['path'])){
                                        if(Storage::exists($supportTeam->image)) Storage::delete($supportTeam->image);
                                    }
                                }
                                $supportTeam->title         =  $team['title'];
                                $supportTeam->sub_title     =  $team['sub_title'];
                                $supportTeam->image         =  $imgData['path'] ?? $supportTeam->image;
                                $supportTeam->value         =  json_encode($team['contact']);
                                $supportTeam->save();
                            }

                            if($supportFaqs && isset($supportData['rfq'])){
                                $rfq = $supportData['rfq'];
                                $imgData = null;
                                if(isset($rfq['image'])){
                                    $imgData = $this->uploadWithFile($rfq['image'], 'uploads/homepage/support_rfq');
                                    if(isset($imgData['path']) && Storage::exists($imgData['path'])){
                                        if(Storage::exists($supportTeam->image)) Storage::delete($supportTeam->image);
                                    }
                                }
                                $supportFaqs->title         =  $rfq['title'];
                                $supportFaqs->sub_title     =  $rfq['sub_title'];
                                $supportFaqs->image         =  $imgData['path'] ?? $supportFaqs->image;
                                $supportFaqs->value         =  json_encode($rfq['button']);
                                $supportFaqs->save();
                            }
                        }
                    }
                }

                return true;
            });

            return redirect()->back()->with('success', 'Homepage details saved successfully.');

        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
