<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FAQs;
use App\Models\FAQCategoriesModel as FAQCategories;
use Validator;
use Str;
use DB;

class FAQsController extends Controller
{
    protected $faqsRepository;

    public function __construct(\App\Repositories\FAQsRepository $faqsRepository)
    {
        $this->faqsRepository = $faqsRepository;
    }

    public function index()
    {
        $faqs = FAQs::select('faq_categories.title', 'faq_categories.id')
            ->join('faq_categories', 'faq_categories.id', 'faqs.category')
            ->groupBy('faqs.category')
            ->orderBy('faqs.id', 'desc')->get();
        return view('admin.faqs.list', compact('faqs'));
    }

    public function add()
    {
        return view('admin.faqs.create');
    }

    public function store(Request $request)
    {

        $input = $request->all();
        $category = $input['category'];

        if (isset($input['question']) && count($input['question']) > 0) {
            foreach ($input['question'] as $k => $data) {
                $input = ['question' => $data, 'answer' => $input['answer'][$k], 'category' => $category];
                $this->faqsRepository->create($input);
            }
        }

        session()->flash('success', 'FAQ has been created successfully!');

        return redirect()->route('admin.faqs.faqs-list')->with('success', 'FAQ created successfully!');
    }

    public function updateView($category_id)
    {
        $faqCategory = FAQCategories::with('faqs')->where('id', $category_id)->first();
        return view('admin.faqs.update', compact('faqCategory'));
    }

    public function update()
    {
        $input = request()->all();
        $category = $input['category'];
        if (isset($input['question']) && count($input['question']) > 0) {
            foreach ($input['question'] as $k => $data) {
                $faqId = $input['faqId'][$k] ?? '';
                $inputData = ['question' => $data, 'answer' => $input['answer'][$k], 'category' => $category];
                if ($faqId) {
                    $this->faqsRepository->where('id', $faqId)->update($inputData);
                } else {
                    $this->faqsRepository->create($inputData);
                }
            }
        }

        session()->flash('success', 'FAQ has been updated successfully!');
        return redirect()->route('admin.faqs.update-faqs', $category)->with('success', 'FAQ updated successfully!');
    }

    public function delete()
    {
        $id = request()->faqId;
        if ($id) {

            $faq = $this->faqsRepository->find($id);
            $category = $faq->category;
            $delete = $faq->delete();

            if ($delete) {
                session()->flash('success', 'FAQ has been deleted successfully!');

                return redirect()->route('admin.faqs.update-faqs', $category)->with('success', 'FAQ deleted successfully!');
            } else {

                session()->flash('success', 'Something went wrong, please try again!');

                return redirect()->route('admin.faqs.update-faqs', $category)->with('error', 'FAQ not deleted');
            }
        }
    }

    public function addCategory()
    {

        return view('admin.faqs.categories.add');
    }

    public function storeCategory(Request $request)
    {

        $input = $request->all();
        $validator = Validator::make($input, [
            'title' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            session()->flash('error', $validator->errors()->first());
            return redirect()->back()->withErrors($validator);
        }

        unset($input['_token']);
        $input['slug'] = Str::slug($input['title'], '-');
        $add = FAQCategories::create($input);

        session()->flash('success', 'FAQ Category has been created successfully!');
        return redirect()->route('admin.faqs.faq-categories')->with('success', 'FAQ Category created successfully!');
    }

    public function faqCategoriesList()
    {

        $categories = FAQCategories::select('id', 'title', 'description')
            ->orderBy('id', 'desc')->paginate(10);
        return view('admin.faqs.categories.list', compact('categories'));
    }

    public function updateCategoryView($id)
    {

        $category = FAQCategories::where('id', $id)->first();
        return view('admin.faqs.categories.edit', compact('category'));
    }

    public function updateCategory(Request $request)
    {

        $input = $request->all();
        $validator = Validator::make($input, [
            'title' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            session()->flash('error', $validator->errors()->first());
            return redirect()->back()->withErrors($validator);
        }
        unset($input['_token']);
        $input['slug'] = Str::slug($input['title'], '-');
        $category = FAQCAtegories::where('id', $input['id'])->update($input);

        session()->flash('success', 'FAQ Category has been updated successfully!');
        return redirect()->route('admin.faqs.update-faq-category-view', $input['id'])->with('success', 'FAQ Category updated successfully!');
    }

    public function deleteFAQCategory()
    {
        $id = request()->id;
        if ($id) {

            $delete = FAQCAtegories::where('id', $id)->delete();

            if ($delete) {
                session()->flash('success', 'FAQ Category has been deleted successfully!');

                return redirect()->route('admin.faqs.faq-categories')->with('success', 'FAQ Category deleted successfully!');
            } else {

                session()->flash('success', 'Something went wrong, please try again!');

                return redirect()->route('admin.faqs.faq-categories')->with('error', 'FAQ Category not deleted');
            }
        }
    }
}
