<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\Validator;

class CustomerController extends Controller
{
    protected $userRepository;

    public function __construct(\App\Repositories\UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function index()
    {
        $customers = User::with('roles')->where('user_type', 3)->orderBy('id', 'desc')->paginate(10);
        return view('admin.customers.list', compact('customers'));
    }

    public function deactivatedList()
    {
        $customers = User::onlyTrashed()->with('roles')->where('user_type', 3)->orderBy('id', 'desc')->paginate(10);
        return view('admin.customers.deactivated_list', compact('customers'));
    }

    public function add()
    {

        $roles = Role::all();
        return view('admin.customers.create', compact('roles'));
    }

    public function update($id)
    {

        $user = User::with('additional_info')->find($id);
        return view('admin.customers.create', compact('user'));
    }

    public function createOrUpdateUser(Request $request)
    {

        $request = $request->all();
        $userInputs = $request['user'] ?? array();
        $userId = $request['id'] ?? 0;

        if (!$userId) {
            $validator = Validator::make($userInputs, [
                'first_name' => 'required|string|max:255',
                'last_name' => 'required|string|max:255',
                'email' => 'required|string|email|unique:users',
                'password' => 'required|string|min:6',
            ]);
        } else {
            $validator = Validator::make($userInputs, [
                'first_name' => 'required|string|max:255',
                'last_name' => 'required|string|max:255',
                'email' => 'required|string|email|unique:users,email,' . $userId,
            ]);
        }


        if ($validator->fails()) {
            session()->flash('error', $validator->errors()->first());
            return redirect()->back()->withErrors($validator);
        }

        $this->userRepository->updateInfo($userId, $request);

        session()->flash('success', 'Customer account has been created successfully!');
        return redirect()->route('admin.customers')->with('success', 'Customer account has been updated successfully!');
    }
}
