<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\ContactPage;
use App\Models\ContactUs;
use App\Http\Traits\Bmf;

class ContactController extends Controller
{
    use Bmf;

    protected $contactUs;
    protected $contactPage;

    public function __construct(
        ContactUs $_contact_us,
        ContactPage $_contact_page
    ) {
        $this->contactUs = $_contact_us;
        $this->contactPage = $_contact_page;
    }

    public function dynamicIndex(Request $request)
    {
        $contactPage = $this->contactPage->where('type', 'contact_page_master_data')->first();
        $contactPagePhone = $this->contactPage->where('type', 'contact_page_phone')->first();
        $contactPageEmail = $this->contactPage->where('type', 'contact_page_email')->first();
        return view('admin.contact_us.dynamic_index', compact('contactPage', 'contactPagePhone', 'contactPageEmail'));
    }

    public function receivedRequests(Request $request)
    {
        $receivedRequests = $this->contactUs->orderBy('id', 'DESC')->get();
        return view('admin.contact_us.requests_list', compact('receivedRequests'));
    }

    public function dynamicStore(Request $request)
    {
        try {
            $response = DB::transaction(function () use ($request) {

                $contactPage = $this->contactPage->where('type', 'contact_page_master_data')->first();
                $contactPagePhone = $this->contactPage->where('type', 'contact_page_phone')->first();
                $contactPageEmail = $this->contactPage->where('type', 'contact_page_email')->first();
                if (!$contactPage) {

                    $contactPageData = [
                        'title'         =>  $request->title ?? 'Contact',
                        'description'   =>  $request->description,
                        'type'          =>  'contact_page_master_data'
                    ];
                    $contactPage = $this->contactPage->create($contactPageData);
                    if ($contactPage) {
                        $image = $this->uploadWithName($request, 'image', 'uploads/contact-us');
                        $contactPage->image = $image['path'] ?? null;
                        $contactPage->save();


                        if (!$contactPagePhone && isset($request->phone)) {
                            $contactPagePhone = $this->contactPage->create([
                                'type'          =>  'contact_page_phone',
                                'title'         =>  'phone',
                                'key'           =>  'phone',
                                'value'         =>  $request->phone
                            ]);
                        }

                        if (!$contactPageEmail && isset($request->email)) {
                            $contactPageEmail = $this->contactPage->create([
                                'type'          =>  'contact_page_email',
                                'title'         =>  'email',
                                'key'           =>  'email',
                                'value'         =>  $request->email
                            ]);
                        }

                        return ['status' => true, 'message' => 'Master Data Saved Successfully.'];
                    }

                    return ['status' => false, 'message' => 'Failed To Save Master Data.'];
                } else {
                    // Update Page Details
                    $contactPage->title = $request->title ?? $contactPage->title;
                    $contactPage->description = $request->description ?? $contactPage->description;
                    $image = $this->uploadWithName($request, 'image', 'uploads/contact-us');
                    if (isset($image['path']) && Storage::exists($image['path'])) {
                        Storage::delete($contactPage->image);
                    }
                    $contactPage->image = $image['path'] ?? $contactPage->image;
                    $contactPage->save();

                    // Update Phone
                    $contactPagePhone->value = $request->phone ?? $contactPagePhone->value;
                    $contactPagePhone->save();

                    // Update Email
                    $contactPageEmail->value = $request->email ?? $contactPageEmail->value;
                    $contactPageEmail->save();

                    return ['status' => true, 'message' => 'Master Data Updated Successfully.'];
                }
            });

            if ($response['status']) {
                return redirect()->back()->with('success', $response['message']);
            }

            return redirect()->back()->with('error', $response['message']);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
