<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $category = Category::select('id', 'category_name')->orderBy('id', 'Asc')->paginate(10);
        return view('admin.categories.list',compact('category'));

    }

    /**
     * Show the form for creating a new resource.
     */
    public function add()
    {
        return view('admin.categories.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function createCategory(Request $request)
    {
        $validatedData = $request->validate([
            'category_name' => 'required|string|max:255|unique:categories,category_name',
        ]);

        try {
            $category = Category::create([
                'category_name' => $request->category_name,
            ]);          
            if ($category) {
                return redirect()->route('admin.categories')->with('success', 'Category added successfully!');
            } else {
                return redirect()->route('AddCategory')->with('error', 'Failed to add category. Please try again.');
            }
        } catch (\Exception $e) {
            return redirect()->route('AddCategory')->with('error', 'Something went wrong: ' . $e->getMessage());
        }

    }

    public function editCategory($id)
    {
        $category = Category::findOrFail($id);
        return view('admin.categories.edit', compact('category'));
    }
   

    public function updateCategory(Request $request, $id)
    {
        $request->validate([
            'category_name' => 'required|max:255|unique:categories,category_name,'.$id
        ]);
        
        try {
            $category = Category::findOrFail($id);
            $category_update = Category::where('id', $id)->update([
                'category_name' => $request->category_name
            ]);

            if ($category_update) {
                return redirect()->route('admin.categories')->with('success', 'Category Updated successfully!');
            } else {
                return redirect()->route('EditCategory')->with('error', 'Failed to update category. Please try again.');
            }
        } catch (\Exception $e) {
                return redirect()->route('EditCategory')->with('error', 'Something went wrong: ' . $e->getMessage());
            } 
     }

}
