<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Http\Traits\Bmf;
use App\Models\AboutUs;
use Illuminate\Support\Facades\Validator;
class AboutUsController extends Controller
{
  use Bmf;

  public function __construct(
    AboutUs $_about_us
  ) {
    $this->aboutUs = $_about_us; 
  }

  public function index(Request $request){
    $aboutUsIntro  = $this->aboutUs->where('type', 'intro')->first();
    $aboutUsTestimonialIntro  = $this->aboutUs->where('type', 'testimonial_intro')->first();
    $aboutUsTeamIntro  = $this->aboutUs->where('type', 'team_intro')->first();
    $aboutUsWhatsDiffIntro  = $this->aboutUs->where('type', 'whats_different_intro')->first();
    return view('admin.about_us.index', compact('aboutUsIntro', 'aboutUsTestimonialIntro', 'aboutUsTeamIntro','aboutUsWhatsDiffIntro'));
  }

  public function store(Request $request){
    $validator = Validator::make($request->all(), [
      // 'name' => 'required|string|max:255',
    ]);

    try{

      $response = DB::transaction(function () use ($request) {

        $data = $request->all();

        //Intro
        if(isset($request->intro)){
          $intro  = $this->aboutUs->where('type', 'intro')->first();
          $introData = $request->intro;
          $introCounts = json_encode(['winner_of_month' => $request->winner_of_month ?? 0, 'ticket_sold' => $request->ticket_sold ?? 0, 'payouts_winner' => $request->payouts_winner?? 0]);
          if(!$intro){
            $intro = $this->aboutUs->create([
              'name'        =>  'intro',
              'title'       =>  $introData['title'],
              'sub_title'   =>  $introData['sub_title'],
              'description' =>  $introData['description'],
              'type'        =>  'intro',
              'value'       =>  $introCounts
            ]);
          }else{
            $intro->title       =   $introData['title'];
            $intro->sub_title   =   $introData['sub_title'];
            $intro->description =   $introData['description'];
            $intro->value       =   $introCounts;
            $intro->save();
          }
        }

        // Testimonial Intro
        if(isset($request->testimonial_intro)){
          $testimonialIntro  = $this->aboutUs->where('type', 'testimonial_intro')->first();
          $testimonialIntroData = $request->testimonial_intro;
          if(!$testimonialIntro){
            $testimonialIntro = $this->aboutUs->create([
              'name'        =>  'testimonial_intro',
              'title'       =>  $testimonialIntroData['title'],
              'sub_title'   =>  $testimonialIntroData['sub_title'],
              'description' =>  $testimonialIntroData['description'],
              'type'        =>  'testimonial_intro',
            ]);
          }else{
            $testimonialIntro->title       =   $testimonialIntroData['title'];
            $testimonialIntro->sub_title   =   $testimonialIntroData['sub_title'];
            $testimonialIntro->description =   $testimonialIntroData['description'];
            $testimonialIntro->save();
          }
        }

        // Team Intro
        if(isset($request->team_intro)){
          $teamIntro  = $this->aboutUs->where('type', 'team_intro')->first();
          $teamIntroData = $request->team_intro;
          if(!$teamIntro){
            $teamIntro = $this->aboutUs->create([
              'name'        =>  'team_intro',
              'title'       =>  $teamIntroData['title'],
              'sub_title'   =>  $teamIntroData['sub_title'],
              'description' =>  $teamIntroData['description'],
              'type'        =>  'team_intro',
            ]);
          }else{
            $teamIntro->title       =   $teamIntroData['title'];
            $teamIntro->sub_title   =   $teamIntroData['sub_title'];
            $teamIntro->description =   $teamIntroData['description'];
            $teamIntro->save();
          }
        }

        // Whats Different Intro
        if(isset($request->whats_different_intro)){
          $whatDifferenceIntro  = $this->aboutUs->where('type', 'whats_different_intro')->first();
          $whatDifferenceIntroData = $request->whats_different_intro;
          $whatDifferenceData = $request->whats_different ?? null;
          $imgData = null;
          if(!empty($whatDifferenceIntroData['image'])){
            $imgData = $this->uploadWithFile($whatDifferenceIntroData['image'], 'uploads/about-us/whats-difference');
          }
          if(!$whatDifferenceIntro){
            $whatDifferenceIntro = $this->aboutUs->create([
              'name'        =>  'whats_different_intro',
              'title'       =>  $whatDifferenceIntroData['title'],
              'sub_title'   =>  $whatDifferenceIntroData['sub_title'],
              'description' =>  $whatDifferenceIntroData['description'],
              'type'        =>  'whats_different_intro',
              'image'       =>  $imgData['path'] ?? null,
            ]);

            if($whatDifferenceIntro && isset($whatDifferenceData['steps'])){
              foreach($whatDifferenceData['steps'] as $key => $step){
                $imgData = $this->uploadWithFile($step['image'], 'uploads/about-us/whats-difference/steps');
                $this->aboutUs->create([
                  'title'         =>  $step['title'],
                  'sub_title'     =>  $step['sub_title'],
                  'image'         =>  $imgData['path'] ?? null,
                  'type'          =>  'whats_different_steps',
                  'reference_id'  =>  $whatDifferenceIntro->id
                ]);
              }
            }
          }else{
            if(isset($imgData['path']) && Storage::exists($imgData['path'])){
              if(Storage::exists($whatDifferenceIntro->image)) Storage::delete($whatDifferenceIntro->image);
            }

            $whatDifferenceIntro->title       =   $whatDifferenceIntroData['title'];
            $whatDifferenceIntro->sub_title   =   $whatDifferenceIntroData['sub_title'];
            $whatDifferenceIntro->description =   $whatDifferenceIntroData['description'];
            $whatDifferenceIntro->image       =   $imgData['path'] ?? $whatDifferenceIntro->image;
            if($whatDifferenceIntro->save() && isset($whatDifferenceData['steps'])){
              foreach($whatDifferenceData['steps'] as $key => $step){
                $imgData = null;
                $whatsDifferenceData = $whatDifferenceIntro->moreRelatedData[$key - 1] ?? [];
                if(isset($step['image']) && !empty($step['image'])){
                    $imgData = $this->uploadWithFile($step['image'], 'uploads/about-us/whats-difference/steps');
                    if(isset($imgData['path']) && Storage::exists($imgData['path'])){
                        if(isset($whatsDifferenceData->image) && Storage::exists($whatsDifferenceData->image)) Storage::delete($whatsDifferenceData->image);
                    }
                }

                if($whatsDifferenceData){
                    $whatsDifferenceData->title         =  $step['title'];
                    $whatsDifferenceData->sub_title     =  $step['sub_title'];
                    $whatsDifferenceData->image         =  isset($imgData['path']) ? $imgData['path'] : $whatsDifferenceData->image;
                    $whatsDifferenceData->save();
                }else{
                    $this->aboutUs->create([
                        'title'         =>  $step['title'],
                        'sub_title'     =>  $step['sub_title'],
                        'image'         =>  isset($imgData['path']) ? $imgData['path'] : $whatsDifferenceData->image,
                        'type'          =>  'whats_different_steps',
                        'reference_id'  =>  $whatDifferenceIntro->id
                    ]);
                }
              }
          }
          }
        }
      });

      return redirect()->back()->with('success', 'About-us details saved successfully.');

    }catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

  public function testimonialIndex(Request $request){
    $testimonials = $this->aboutUs->where('type', 'testimonials')->orderBy('id', 'DESC')->get();
    return view('admin.about_us.testimonials.list', compact('testimonials'));
  }

  public function testimonialCreate(Request $request){
    return view('admin.about_us.testimonials.add');
  }

  public function testimonialStore(Request $request){
    try {
      $response = DB::transaction(function () use ($request) {
        $testimonialsData = [
          'name'         =>   $request->name,
          'description'  =>   $request->description,
          'value'        =>   $request->value,
          'type'         =>   'testimonials'
        ];

        $testimonial = $this->aboutUs->create($testimonialsData);
        if($testimonial){
          $image = $this->uploadWithName($request, 'image', 'uploads/testimonials');
          $testimonial->image = $image['path'] ?? null;
          $testimonial->save();

          return ['status' => true, 'message' => 'Testimonial Saved Successfully.'];
        }

        return ['status' => false, 'message' => 'Failed To Save Testimonial.'];
      });

      if($response['status']){
        return redirect()->route('admin.about_us.testimonial.index')->with('success', $response['message']);
      }

      return redirect()->back()->with('error', $response['message']);
    } catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

  public function testimonialEdit(Request $request){
    $testimonial = $this->aboutUs->find($request->id);
    return view('admin.about_us.testimonials.edit', compact('testimonial'));
  }

  public function testimonialUpdate(Request $request){
    try {
      $testimonial = $this->aboutUs->find($request->id);
      if(!$testimonial){
        return redirect()->back()->with('error', 'Invalid request to update testimonial.');
      }

      $response = DB::transaction(function () use ($request, $testimonial) {
        $testimonial->name  = $request->name ?? $testimonial->name;
        $testimonial->description  = $request->description ?? $testimonial->description;
        $testimonial->value  = $request->value ?? $testimonial->value;
        if($testimonial->save()){
          $image = $this->uploadWithName($request, 'image', 'uploads/testimonials');
          if(isset($image['path']) && Storage::exists($image['path'])){
            if(Storage::exists($testimonial->image)) Storage::delete($testimonial->image);
          }
          $testimonial->image = $image['path'] ?? $testimonial->image;
          $testimonial->save();

          return ['status' => true, 'message' => 'Testimonial Updated Successfully.'];
        }

        return ['status' => false, 'message' => 'Failed To Update Testimonial.'];
      });


      if($response['status']){
        return redirect()->route('admin.about_us.testimonial.index')->with('success', $response['message']);
      }

      return redirect()->back()->with('error', $response['message']);

    } catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

  public function testimonialDelete(Request $request){
    try {
      $testimonial = $this->aboutUs->find($request->id);
      if(!$testimonial){
        return redirect()->back()->with('error', 'Invalid request to update testimonial.');
      }

      $response = DB::transaction(function () use ($request, $testimonial) {
        $image = $testimonial->image;
        if($testimonial->delete()){
          if(Storage::exists($image)) Storage::delete($image);

          return ['status' => true, 'message' => 'Testimonial deleted successfully.'];
        }

        return ['status' => false, 'message' => 'Failed To delete testimonial.'];
      });

      if($response['status']){
        return redirect()->route('admin.about_us.testimonial.index')->with('success', $response['message']);
      }

      return redirect()->back()->with('error', $response['message']);

    } catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

  public function teamIndex(Request $request){
    $teamMembers = $this->aboutUs->where('type', 'team')->orderBy('id', 'DESC')->get();
    return view('admin.about_us.team.list', compact('teamMembers'));
  }

  public function teamCreate(Request $request){
    return view('admin.about_us.team.add');
  }

  public function teamStore(Request $request){
    try {
      $response = DB::transaction(function () use ($request) {
        $teamData = [
          'name'         =>   $request->name,
          'title'        =>   $request->title,
          'type'         =>   'team'
        ];

        $team = $this->aboutUs->create($teamData);
        if($team){
          $image = $this->uploadWithName($request, 'image', 'uploads/team');
          $team->image = $image['path'] ?? null;
          $team->save();

          return ['status' => true, 'message' => 'Team Member Saved Successfully.'];
        }

        return ['status' => false, 'message' => 'Failed To Save Team Member.'];
      });

      if($response['status']){
        return redirect()->route('admin.about_us.team.index')->with('success', $response['message']);
      }

      return redirect()->back()->with('error', $response['message']);
    } catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

  public function teamEdit(Request $request){
    $team = $this->aboutUs->find($request->id);
    return view('admin.about_us.team.edit', compact('team'));
  }

  public function teamUpdate(Request $request){
    try {
      $team = $this->aboutUs->find($request->id);
      if(!$team){
        return redirect()->back()->with('error', 'Invalid request to update team member.');
      }

      $response = DB::transaction(function () use ($request, $team) {
        $team->name  = $request->name ?? $team->name;
        $team->title  = $request->title ?? $team->title;
        if($team->save()){
          $image = $this->uploadWithName($request, 'image', 'uploads/testimonials');
          if(isset($image['path']) && Storage::exists($image['path'])){
            if(Storage::exists($team->image)) Storage::delete($team->image);
          }
          $team->image = $image['path'] ?? $team->image;
          $team->save();

          return ['status' => true, 'message' => 'Team Member Updated Successfully.'];
        }

        return ['status' => false, 'message' => 'Failed To Update Team Member.'];
      });


      if($response['status']){
        return redirect()->route('admin.about_us.team.index')->with('success', $response['message']);
      }

      return redirect()->back()->with('error', $response['message']);

    } catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

  public function teamDelete(Request $request){
    try {
      $team = $this->aboutUs->find($request->id);
      if(!$team){
        return redirect()->back()->with('error', 'Invalid request to update testimonial.');
      }

      $response = DB::transaction(function () use ($request, $team) {
        $image = $team->image;
        if($team->delete()){
          if(Storage::exists($image)) Storage::delete($image);

          return ['status' => true, 'message' => 'Team Member deleted successfully.'];
        }

        return ['status' => false, 'message' => 'Failed To delete team member.'];
      });

      if($response['status']){
        return redirect()->route('admin.about_us.team.index')->with('success', $response['message']);
      }

      return redirect()->back()->with('error', $response['message']);

    } catch (\Throwable $th) {
      return redirect()->back()->with('error', $th->getMessage());
    }
  }

}
