<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use App\Http\Traits\HttpResponses;
use Route;

class Handler extends ExceptionHandler
{
    use HttpResponses;

    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    // public function register()
    // {
    //     $this->reportable(function (Throwable $e) {
    //         //
    //     });

    //     $this->reportable(function (Throwable $e, Request $request) {

    //         if ($e instanceof \Illuminate\Session\TokenMismatchException) {
    //             // Redirect to the home page on CSRF token mismatch (419 error)
    //             return redirect()->route('home')->with('error', 'Session expired. Please try again.');
    //         }

    //         return parent::render($request, $e);
    //     });

    //     $this->renderable(function (MethodNotAllowedHttpException $exception, Request $request) {
    //         return response()->view('errors.500', [], 500);
    //     });

    //     $this->renderable(function (NotFoundHttpException $e, Request $request) {
    //         if ($request->is('api/*')) {
    //             return $this->notFound('Record not found.');
    //         }
    //     });

    //     $this->renderable(function (MethodNotAllowedHttpException $e, Request $request) {
    //         if ($request->is('api/*')) {
    //             return $this->invalidMethod($request->method() . ' Method is not allowed for the requested route', $e);
    //         }
    //     });
    // }

    public function register()
{
    $this->reportable(function (Throwable $e) {
        if ($e instanceof \Illuminate\Session\TokenMismatchException) {
            return redirect()->route('home')->with('error', 'Session expired. Please try again.');
        }
    });

    $this->renderable(function (MethodNotAllowedHttpException $exception, Request $request) {
        return response()->view('errors.500', [], 500);
    });

    $this->renderable(function (NotFoundHttpException $e, Request $request) {
        if ($request->is('api/*')) {
            return $this->notFound('Record not found.');
        }
    });

    $this->renderable(function (MethodNotAllowedHttpException $e, Request $request) {
        if ($request->is('api/*')) {
            return $this->invalidMethod($request->method() . ' Method is not allowed for the requested route', $e);
        }
    });
}

}
