<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Contests;
use App\Models\OrdersTickets;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendDrawMail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:draw-mail';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send Draw Mail';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $mail = new \App\Services\EmailService();
        $currentDateTime = Carbon::now();
        $orderContest = Contests::join('orders_tickets as ot', 'ot.contest_id', 'contests.id')
            ->whereDate('draw_date', '=', $currentDateTime)
            ->groupBy('ot.user_id')
            ->get();
        $customerIds = array_unique($orderContest->pluck('user_id')->toArray());
        $customers = DB::table('users')->whereIn('id', $customerIds)->where('user_type', 3)->whereNull('deleted_at')->get();
        $contestIds = [];
        foreach ($orderContest as $contest) {
            if (!in_array($contest->contest_id, $contestIds)) {
                $contestIds[] = $contest->contest_id;
                foreach ($customers as $k => $customer) {
                    $to = $customer->email;
                    $subject = 'IT\'S DRAW DAY TODAY! 🎉';
                    $view = 'emails.draw-day';
                    $data['contest'] = $contest;
                    $data['customer'] = $customer;
                    $send = $mail->sendEmail($to, $data, $view, $subject);
                }
            }
        }
    }
}
